-- template.vhd -> 'design_name.vhd'
--
-- Author: Nial Stewart, Nial Stewart Developments Ltd.
--         www.nialstewart.co.uk
--         Jan '03
--
-- This header is repeated for the template.vhd and 'design_name.vhd' files.
--
-- The Perl routine vir2spart.pl reads in the template.vhd file and 
-- replaces the 'INITX_Y' strings with the correct values derived
-- from the VirtexII Blockram initialisation values.
--


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library unisim;
use unisim.vcomponents.all;


entity picocode is
    Port (      address : in std_logic_vector(9 downto 0);
            instruction : out std_logic_vector(17 downto 0);
                    clk : in std_logic);
    end picocode;

architecture ram_insts of picocode is

attribute INIT_00 : string; 
attribute INIT_01 : string; 
attribute INIT_02 : string; 
attribute INIT_03 : string; 
attribute INIT_04 : string; 
attribute INIT_05 : string; 
attribute INIT_06 : string; 
attribute INIT_07 : string; 
attribute INIT_08 : string; 
attribute INIT_09 : string; 
attribute INIT_0A : string; 
attribute INIT_0B : string; 
attribute INIT_0C : string; 
attribute INIT_0D : string; 
attribute INIT_0E : string; 
attribute INIT_0F : string; 


-- Attributes to define ROM contents for synthesis.

attribute INIT_00 of ram_1 : label is  "INIT1_0";
attribute INIT_01 of ram_1 : label is  "INIT1_1";
attribute INIT_02 of ram_1 : label is  "INIT1_2";
attribute INIT_03 of ram_1 : label is  "INIT1_3";
attribute INIT_04 of ram_1 : label is  "INIT1_4";
attribute INIT_05 of ram_1 : label is  "INIT1_5";
attribute INIT_06 of ram_1 : label is  "INIT1_6";
attribute INIT_07 of ram_1 : label is  "INIT1_7";
attribute INIT_08 of ram_1 : label is  "INIT1_8";
attribute INIT_09 of ram_1 : label is  "INIT1_9";
attribute INIT_0A of ram_1 : label is  "INIT1_10";
attribute INIT_0B of ram_1 : label is  "INIT1_11";
attribute INIT_0C of ram_1 : label is  "INIT1_12";
attribute INIT_0D of ram_1 : label is  "INIT1_13";
attribute INIT_0E of ram_1 : label is  "INIT1_14";
attribute INIT_0F of ram_1 : label is  "INIT1_15";

attribute INIT_00 of ram_2 : label is  "INIT2_0";
attribute INIT_01 of ram_2 : label is  "INIT2_1";
attribute INIT_02 of ram_2 : label is  "INIT2_2";
attribute INIT_03 of ram_2 : label is  "INIT2_3";
attribute INIT_04 of ram_2 : label is  "INIT2_4";
attribute INIT_05 of ram_2 : label is  "INIT2_5";
attribute INIT_06 of ram_2 : label is  "INIT2_6";
attribute INIT_07 of ram_2 : label is  "INIT2_7";
attribute INIT_08 of ram_2 : label is  "INIT2_8";
attribute INIT_09 of ram_2 : label is  "INIT2_9";
attribute INIT_0A of ram_2 : label is  "INIT2_10";
attribute INIT_0B of ram_2 : label is  "INIT2_11";
attribute INIT_0C of ram_2 : label is  "INIT2_12";
attribute INIT_0D of ram_2 : label is  "INIT2_13";
attribute INIT_0E of ram_2 : label is  "INIT2_14";
attribute INIT_0F of ram_2 : label is  "INIT2_15";

attribute INIT_00 of ram_3 : label is  "INIT3_0";
attribute INIT_01 of ram_3 : label is  "INIT3_1";
attribute INIT_02 of ram_3 : label is  "INIT3_2";
attribute INIT_03 of ram_3 : label is  "INIT3_3";
attribute INIT_04 of ram_3 : label is  "INIT3_4";
attribute INIT_05 of ram_3 : label is  "INIT3_5";
attribute INIT_06 of ram_3 : label is  "INIT3_6";
attribute INIT_07 of ram_3 : label is  "INIT3_7";
attribute INIT_08 of ram_3 : label is  "INIT3_8";
attribute INIT_09 of ram_3 : label is  "INIT3_9";
attribute INIT_0A of ram_3 : label is  "INIT3_10";
attribute INIT_0B of ram_3 : label is  "INIT3_11";
attribute INIT_0C of ram_3 : label is  "INIT3_12";
attribute INIT_0D of ram_3 : label is  "INIT3_13";
attribute INIT_0E of ram_3 : label is  "INIT3_14";
attribute INIT_0F of ram_3 : label is  "INIT3_15";

attribute INIT_00 of ram_4 : label is  "INIT4_0";
attribute INIT_01 of ram_4 : label is  "INIT4_1";
attribute INIT_02 of ram_4 : label is  "INIT4_2";
attribute INIT_03 of ram_4 : label is  "INIT4_3";
attribute INIT_04 of ram_4 : label is  "INIT4_4";
attribute INIT_05 of ram_4 : label is  "INIT4_5";
attribute INIT_06 of ram_4 : label is  "INIT4_6";
attribute INIT_07 of ram_4 : label is  "INIT4_7";
attribute INIT_08 of ram_4 : label is  "INIT4_8";
attribute INIT_09 of ram_4 : label is  "INIT4_9";
attribute INIT_0A of ram_4 : label is  "INIT4_10";
attribute INIT_0B of ram_4 : label is  "INIT4_11";
attribute INIT_0C of ram_4 : label is  "INIT4_12";
attribute INIT_0D of ram_4 : label is  "INIT4_13";
attribute INIT_0E of ram_4 : label is  "INIT4_14";
attribute INIT_0F of ram_4 : label is  "INIT4_15";

attribute INIT_00 of ram_5 : label is  "INIT5_0";
attribute INIT_01 of ram_5 : label is  "INIT5_1";
attribute INIT_02 of ram_5 : label is  "INIT5_2";
attribute INIT_03 of ram_5 : label is  "INIT5_3";
attribute INIT_04 of ram_5 : label is  "INIT5_4";
attribute INIT_05 of ram_5 : label is  "INIT5_5";
attribute INIT_06 of ram_5 : label is  "INIT5_6";
attribute INIT_07 of ram_5 : label is  "INIT5_7";
attribute INIT_08 of ram_5 : label is  "INIT5_8";
attribute INIT_09 of ram_5 : label is  "INIT5_9";
attribute INIT_0A of ram_5 : label is  "INIT5_10";
attribute INIT_0B of ram_5 : label is  "INIT5_11";
attribute INIT_0C of ram_5 : label is  "INIT5_12";
attribute INIT_0D of ram_5 : label is  "INIT5_13";
attribute INIT_0E of ram_5 : label is  "INIT5_14";
attribute INIT_0F of ram_5 : label is  "INIT5_15";

signal  data_out  : std_logic_vector(3 downto 0);

--
begin
--
  --Instantiate the Xilinx primitive for a block RAM
  ram_1: RAMB4_S4
  --translate_off
  --INIT values repeated for each RAM to define contents for functional simulation
  generic map (INIT_00 => X"INIT1_0",
               INIT_01 => X"INIT1_1",
               INIT_02 => X"INIT1_2",
               INIT_03 => X"INIT1_3",
               INIT_04 => X"INIT1_4",
               INIT_05 => X"INIT1_5",
               INIT_06 => X"INIT1_6",
               INIT_07 => X"INIT1_7",
               INIT_08 => X"INIT1_8",
               INIT_09 => X"INIT1_9",
               INIT_0A => X"INIT1_10",
               INIT_0B => X"INIT1_11",
               INIT_0C => X"INIT1_12",
               INIT_0D => X"INIT1_13",
               INIT_0E => X"INIT1_14",
               INIT_0F => X"INIT1_15"
               )
  --translate_on
  port map(    DI => "0000",
               EN => '1',
               WE => '0',
               RST => '0',
               CLK => clk,
               ADDR => address,
               DO => data_out); 

instruction(17 downto 16) <= data_out(1 downto 0); -- Lose top 2 bits               
               
  ram_2: RAMB4_S4
  --translate_off
  generic map (INIT_00 => X"INIT2_0",
               INIT_01 => X"INIT2_1",
               INIT_02 => X"INIT2_2",
               INIT_03 => X"INIT2_3",
               INIT_04 => X"INIT2_4",
               INIT_05 => X"INIT2_5",
               INIT_06 => X"INIT2_6",
               INIT_07 => X"INIT2_7",
               INIT_08 => X"INIT2_8",
               INIT_09 => X"INIT2_9",
               INIT_0A => X"INIT2_10",
               INIT_0B => X"INIT2_11",
               INIT_0C => X"INIT2_12",
               INIT_0D => X"INIT2_13",
               INIT_0E => X"INIT2_14",
               INIT_0F => X"INIT2_15"
               )
  --translate_on
  port map(    DI => "0000",
               EN => '1',
               WE => '0',
               RST => '0',
               CLK => clk,
               ADDR => address,
               DO => instruction(15 downto 12)
               );               
               

  ram_3: RAMB4_S4
  --translate_off
  generic map (INIT_00 => X"INIT3_0",
               INIT_01 => X"INIT3_1",
               INIT_02 => X"INIT3_2",
               INIT_03 => X"INIT3_3",
               INIT_04 => X"INIT3_4",
               INIT_05 => X"INIT3_5",
               INIT_06 => X"INIT3_6",
               INIT_07 => X"INIT3_7",
               INIT_08 => X"INIT3_8",
               INIT_09 => X"INIT3_9",
               INIT_0A => X"INIT3_10",
               INIT_0B => X"INIT3_11",
               INIT_0C => X"INIT3_12",
               INIT_0D => X"INIT3_13",
               INIT_0E => X"INIT3_14",
               INIT_0F => X"INIT3_15"
               )
  --translate_on
  port map(    DI => "0000",
               EN => '1',
               WE => '0',
               RST => '0',
               CLK => clk,
               ADDR => address,
               DO => instruction(11 downto 8)
               );   
               
               
               
  ram_4: RAMB4_S4
  --translate_off
  generic map (INIT_00 => X"INIT4_0",
               INIT_01 => X"INIT4_1",
               INIT_02 => X"INIT4_2",
               INIT_03 => X"INIT4_3",
               INIT_04 => X"INIT4_4",
               INIT_05 => X"INIT4_5",
               INIT_06 => X"INIT4_6",
               INIT_07 => X"INIT4_7",
               INIT_08 => X"INIT4_8",
               INIT_09 => X"INIT4_9",
               INIT_0A => X"INIT4_10",
               INIT_0B => X"INIT4_11",
               INIT_0C => X"INIT4_12",
               INIT_0D => X"INIT4_13",
               INIT_0E => X"INIT4_14",
               INIT_0F => X"INIT4_15"
               )
  --translate_on
  port map(    DI => "0000",
               EN => '1',
               WE => '0',
               RST => '0',
               CLK => clk,
               ADDR => address,
               DO => instruction(7 downto 4)
               );
               
               
               
  ram_5: RAMB4_S4
  --translate_off
  generic map (INIT_00 => X"INIT5_0",
               INIT_01 => X"INIT5_1",
               INIT_02 => X"INIT5_2",
               INIT_03 => X"INIT5_3",
               INIT_04 => X"INIT5_4",
               INIT_05 => X"INIT5_5",
               INIT_06 => X"INIT5_6",
               INIT_07 => X"INIT5_7",
               INIT_08 => X"INIT5_8",
               INIT_09 => X"INIT5_9",
               INIT_0A => X"INIT5_10",
               INIT_0B => X"INIT5_11",
               INIT_0C => X"INIT5_12",
               INIT_0D => X"INIT5_13",
               INIT_0E => X"INIT5_14",
               INIT_0F => X"INIT5_15"
               )
  --translate_on
  port map(    DI => "0000",
               EN => '1',
               WE => '0',
               RST => '0',
               CLK => clk,
               ADDR => address,
               DO => instruction(3 downto 0)
               );               
               
               
              
end ram_insts;

