# ! /usr/bin/perl 

# vir2spart.pl
# 
# This is a Perl utility written to convert initialisation
# definitions from Virtex Blockram (1024 x 18 bits) to SpartanII
# Blockram (5 * 256 x 4 bits) format. 
#
# This is to allow the bigger version of the Picoblaze processor
# to be used with SpartanII devices.
#
# This is provided as is for general use without any guarantees or 
# warranties.
#
#  Nial Stewart Developments 2003
# www.nialstewartdevelopments.co.uk
  
use strict;


my $hex_file_in;
my @source;

my @template;

my $line_in;

my $line_count;
my $line_position;
my $ram_number;

my $subst_string; 

# Create 5 arrays for the initilisation parameters
my @init1;      
my @init2;
my @init3;
my @init4;
my @init5;


$hex_file_in = $ARGV[0];

open IP,"$hex_file_in" or die $!;

# Read in contents of hex file
@source = <IP>;

$line_count = 0;
$line_position = 1;

foreach (@source){
    chomp $_;                                       # Remove any newlines
    /([0-9A-Za-z])([0-9A-Za-z])([0-9A-Za-z])([0-9A-Za-z])([0-9A-Za-z])/; # Do a match on 5 hex characters;
    $init1[$line_count] = "$1$init1[$line_count]";  # Add each character to the start of it's initialisation..
    $init2[$line_count] = "$2$init2[$line_count]";  # ..string, keeping a count and moving to the next line..
    $init3[$line_count] = "$3$init3[$line_count]";  # ..of the array after 64 characters.
    $init4[$line_count] = "$4$init4[$line_count]";
    $init5[$line_count] = "$5$init5[$line_count]";
    $line_position++;
    if ($line_position == 65){
        $line_count++;
        $line_position = 1;
    }
}



# Now read in the template file and substiture in all the initilisation parameters.

open TEMPLATE,"template.vhd" or die $!;
@template = <TEMPLATE>;

foreach (@template){
    
    $line_count = 16;
    until($line_count == 0){
        $line_count--;
        $subst_string = "INIT1_$line_count";
        s/$subst_string/$init1[$line_count]/;
        
        $subst_string = "INIT2_$line_count";
        s/$subst_string/$init2[$line_count]/;
        
        $subst_string = "INIT3_$line_count";
        s/$subst_string/$init3[$line_count]/;
        
        $subst_string = "INIT4_$line_count";
        s/$subst_string/$init4[$line_count]/;
        
        $subst_string = "INIT5_$line_count";
        s/$subst_string/$init5[$line_count]/;
    }
        
}


# Open picocode.vhd for writing...

open OP,"> picocode.vhd" or die $1;

# ..and output the data.

foreach (@template){
    print OP $_;
}    

