-----------------------------------------------------------------
--
--  data_register_out.vhd
--
--  Author: Nial Stewart, Nial Stewart Developments Ltd.
--          www.nialstewart.co.uk
--          Jan '03
--
-- Thia module replaces the module of the same name in Xilinx's 
-- Picoblaze2 (kcpsm2.vhd) when it's being target at a 
-- SpartanII device.
-- 
-- Kcpsm2 is targeted at a VirtexII architecture, this module
-- uses a distributed 32x1 dual port ram. The Spartan doesn't
-- support this so 2 16x1 dual ports are used instead.
--
-- The original module should be commented out and this module
-- added to the list of project source files.
-----------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;


library unisim;
use unisim.vcomponents.all;

entity data_register_bank is
Port (clk         : in std_logic;
      Address_A   : in std_logic_vector(4 downto 0);
      Din_A_bus   : in std_logic_vector(7 downto 0);
      Write_A_bus : in std_logic;
      Dout_A_bus  : out std_logic_vector(7 downto 0);    
      Address_B   : in  std_logic_vector(4 downto 0);
      Dout_B_bus  : out std_logic_vector(7 downto 0) 
      );
end data_register_bank;

architecture rtl of data_register_bank is

signal we_h       : std_logic;
signal we_l       : std_logic;

signal rd_a_low   : std_logic_vector(7 downto 0);
signal rd_a_high  : std_logic_vector(7 downto 0);
signal rd_b_low   : std_logic_vector(7 downto 0);
signal rd_b_high  : std_logic_vector(7 downto 0);




begin

-- Generate the two write strobes for high and low 
-- ram, and select correct output byte for each port.

we_l <= Write_A_bus and (not Address_A(4));
we_h <= Write_A_bus and Address_A(4);

Dout_A_bus <= rd_a_high when (Address_A(4) = '1') else rd_a_low;
Dout_B_bus <= rd_b_high when (Address_B(4) = '1') else rd_b_low;



 
bus_width_loop: for i in 0 to 7 generate
  -- Attribute to define RAM contents during synthesis & P+R
  attribute INIT : string; 
  attribute INIT of data_low  : label is "0000"; 
  attribute INIT of data_high : label is "0000";

  begin
    data_low: ram16x1d
    -- translate_off
    generic map(INIT => x"0000")
    -- translate_on
    port map( WCLK  => clk,
              WE    => we_l,
              D     => Din_A_bus(i),
              A0    => Address_A(0),
              A1    => Address_A(1),
              A2    => Address_A(2),
              A3    => Address_A(3),
              
              DPRA0 => Address_B(0),
              DPRA1 => Address_B(1),
              DPRA2 => Address_B(2),
              DPRA3 => Address_B(3),
              
              SPO   => rd_a_low(i),
              DPO   => rd_b_low(i)
              );
              
    data_high: ram16x1d
    -- translate_off
    generic map(INIT => x"0000")
    -- translate_on
    port map( WCLK  => clk,
              WE    => we_h,
              D     => Din_A_bus(i),
              A0    => Address_A(0),
              A1    => Address_A(1),
              A2    => Address_A(2),
              A3    => Address_A(3),
              
              DPRA0 => Address_B(0),
              DPRA1 => Address_B(1),
              DPRA2 => Address_B(2),
              DPRA3 => Address_B(3),
              
              SPO   => rd_a_high(i),
              DPO   => rd_b_high(i)
              );  
  
  end generate bus_width_loop;

end rtl;